/*
* log.h - extracted from zdkimfilter/src/parm.h by ale in milano on 24jun2014
* logging utilities and weariness

Copyright (C) 2014-2019 Alessandro Vesely

This file is part of avfilter

avfilter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

avfilter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License version 3
along with avfilter.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined LOG_H_INCLUDED
#include <stdint.h>
#include <stdio.h> // for FILE

// syslog style log functions
typedef
#if defined __GNUC__
__attribute__ ((format(printf, 3, 4)))
#endif
void (*filelog_t)(FILE*, int, const char*, ...);

typedef
#if defined __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
void (*stdlog_t)(int, const char*, ...);

stdlog_t set_parm_logfun(stdlog_t);

const char* set_program_name(const char * new_name);
#if defined __GNUC__
__attribute__ ((format(printf, 3, 4)))
#endif
void filelog(FILE* fp, int severity, char const* fmt, ...);
#if defined __GNUC__
__attribute__ ((format(printf, 2, 3)))
#endif
void stdlog(int severity, char const* fmt, ...);
int set_log_verbose(int);
int set_log_no_pid(int);
FILE *set_log_file(FILE *fp);
int is_severity_encoded(char const*, int*, size_t*);
enum cl_msg; // in clamav.h
void clamav_msg(enum cl_msg, const char *, const char *, void *);

#define LOG_H_INCLUDED
#endif
