/*
** scan_api.c - written in milano by vesely on 9 jan 2017
** clamav interface for courier-mta global filters
**
** This file is part of avfilter
**
** Copyright (c) 2017 Alessandro Vesely
** All rights reserved. see COPYING
*/
#define _GNU_SOURCE
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <clamav.h>
#include <syslog.h> // for LOG_XXXX defs

#include "scan_api.h"
#include "log.h"

#include <assert.h>

static int add_name(virus_name_list **l, char const *name)
{
	assert(name != NULL);

	if (name)
	{
		size_t const len = strlen(name);
		virus_name_list *n = malloc(len + sizeof(virus_name_list));
		if (n)
		{
			n->next = *l;
			memcpy(&n->name[0], name, len + 1);
			*l = n;
			return 0; // good
		}
	}

	return -1; // fail
}

void free_virus_name_list(virus_name_list *l)
{
	while (l)
	{
		virus_name_list *t = l->next;
		free(l);
		l = t;
	}
}

#define DEAD_BEEF 0xdeadbeefUL

typedef struct vir_names
{
	virus_name_list *l;
	unsigned long dead_beef;
	unsigned count, errors;
} vir_names;

void virus_found_cb(int fd, const char *virname, void *context)
{
	if (context)
	{
		vir_names *vn = (vir_names*)context;
		if (vn->dead_beef != DEAD_BEEF)
			filelog(stderr, LOG_CRIT, "callback error: BAD CONTEXT");
		else
		{
			vn->count += 1;
			if (virname == 0)
				filelog(stderr, LOG_CRIT, "callback error: no name");
			else if (add_name(&vn->l, virname))
				++vn->errors;
		}
	}

	return;

	(void)fd; // not used
}

int my_scandesc(int desc, char const *desc_fname, virus_name_list **vnl,
	const struct cl_engine *engine, struct cl_scan_options* scanoptions)
/*
* call scan function with callback;
* assume cl_engine_set_clcb_virus_found(*, virus_found_cb) was called;
*/
{
	const char *virname;
	vir_names lst;
	unsigned long int scanned;
	int cl;

	memset(&lst, 0, sizeof lst);
	lst.dead_beef = DEAD_BEEF;
	cl = cl_scandesc_callback(desc, desc_fname, &virname, &scanned, engine, scanoptions, &lst);

	if (lst.errors == 0)
		*vnl = lst.l;
	else
	{
		filelog(stderr, LOG_CRIT,
			"callback error(s): %d out of %d calls", lst.errors, lst.count);
		free_virus_name_list(lst.l);
		*vnl = NULL;
	}

	return cl;
}

