/*
* parm.h - copied from zdkimfilter/src by ale in milano on 24jun2014
* parameter file parsing

Copyright (C) 2014-2025 Alessandro Vesely

This file is part of avfilter

avfilter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

avfilter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License version 3
along with avfilter.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined PARM_H_INCLUDED
#include <stdint.h>
#include <stdio.h> // for FILE
#include <clamav.h>
#include "filter_msg.h" // for action_default

/*
* array of string type (incremental)
*/
typedef struct charray
{
	size_t count, alloc, strsize, stralloc;
	char *array[];
} charray;

#define CHARRAY_FIRST_STRING(cha) (char*)(&((cha).array[(cha).alloc]))
#define CHARRAY_OFF_THE_END(cha) (CHARRAY_FIRST_STRING(cha) + (cha).stralloc)

typedef unsigned char is_defined_bitflag[10];
typedef struct malloced_parm
{
	void *malloced;
	struct malloced_parm* next;
} malloced_parm;

/*
* each option has to be defined in three places: in the structure below,
* in the conf[] array in parm.c, and in etc/avfilter.conf.dist.in
* the order here reflects how the data is laid out in memory.
*/
typedef struct parm_t
{
#if defined(TEST_ARRAY)
	charray *test; // DEBUG
#endif

	malloced_parm *freable;

	char *save_virus, *save_missed, *tempdir, *database, *piddir;  // directories

	char *virus_header;

	charray *pua;
	charray *pass, *reject, *drop; // exceptions to action_default
	charray *pass_recipient, *always_pass;

	uint64_t max_scansize;
	uint64_t max_filesize;
	uint64_t max_embeddedpe;
	uint64_t max_htmlnormalize;
	uint64_t max_htmlnotags;
	uint64_t max_scriptnormalize;
	uint64_t max_ziptypercg;

	struct cl_scan_options scan_options;
	unsigned int load_options;

	uint32_t bytecode_timeout;
	uint32_t max_files;
	uint32_t max_recursion;
	uint32_t structured_ssn_count;
	uint32_t structured_cc_count;

	filter_msg_action action_default; // "pass/reject/drop
	uint8_t verbose;
	char all_mode;
	char save_only_if_drop;
	// char reject_broken_archive;
	uint8_t bytecode_mode;            // "ForceJIT/ForceInterpreter

	char dev_ac_only;
	char dev_ac_depth;
	char leave_temps;
	char force_to_disk;
	char bytecode_statistics;

	char applied_parm_defaults;  // set by apply_parm_defaults;
	is_defined_bitflag is_defined;
} parm_t;


int read_all_values(parm_t *parm, char const *fname);
char *read_directory(char const *fname, char const *name);
void clear_parm(parm_t *parm);

#if !defined NO_CLAMAV_FUNCTIONS
void apply_parm_defaults(parm_t *parm);
int set_engine_values(parm_t const *parm, struct cl_engine *clamav);
void print_parm(parm_t const *parm);
#endif

#define PARM_H_INCLUDED
#endif
